#version 330

uniform sampler2D diffuseY, diffuseG, diffuseR, diffuseB, diffuseBl, normalMap, specularMap, rust;
uniform float shininess = 80;
uniform float rusting = 0.2; 


in	vec3 eye;
in	vec2 texCoord;
in	vec3 ld;
in  vec3 n;


out vec4 colorOut;

float perlinNoise(vec3 pos);

void main() {

	vec4 color = texture(diffuseY, texCoord);

	// normalize both input vectors
	vec3 en = normalize(eye);
	vec3 ln = normalize(ld);
    vec3 nn = normalize(n);

	float intensity = max(dot(nn, ln), 0.0);

    float texSpecular = texture(specularMap, texCoord).r;
	vec4 spec = vec4(0.0);
	// if the vertex is lit compute the specular color
	if (intensity > 0.0 ) {
		// compute the half vector
		vec3 h = normalize(ln + en);	
		// compute the specular intensity
		float intSpec = max(dot(h,nn), 0.0);
		// compute the specular term into spec
		spec = vec4(pow(intSpec,shininess)) * texSpecular;
	}


	colorOut = max(intensity*2 * color + spec, color * 0.25);
}

