#version 460

uniform sampler2DMS texUnit;
uniform sampler2D texNormal;
uniform int samples = 32;
uniform vec2 vp_dim;

in vec2 tc;

out vec4 outputF;

void main() {

    vec3 n = texture(texNormal, tc).rgb;
    if (n == vec3(0,0,0))
        discard;

	ivec2 t = ivec2(tc.xy * vp_dim);

	outputF = vec4(0.0);
	for (int i = 0; i < samples; ++i) {
		outputF += texelFetch(texUnit, t , i) ;
	}
	outputF = outputF/samples;
}
