#version 460

uniform	mat4 m_PVM, m_VM, m_V, m_PV;
uniform	mat3 m_normal;
uniform vec4 l_dir;

in vec4 position;
in vec3 normal;


out Data {
	vec3 normal;
	vec3 eye;
	vec3 l_dir;
    flat vec3 color;
} DataOut;

vec3 randVec3(int index) {
    float x = abs(fract(sin(float(index) * 12.9898) * 43758.5453));
    float y = abs(fract(sin(float(index) * 78.233) * 12413.9234));
    float z = abs(fract(sin(float(index) * 54.53) * 9817.123));
    return vec3(x, y, z);
}

void main () {

	DataOut.normal = m_normal * normal; 
	DataOut.eye = -vec3(m_VM * position);
	DataOut.l_dir = normalize(vec3(m_V * -l_dir)); 
    DataOut.color = randVec3(gl_InstanceID);

	gl_Position = m_PVM * position;
}