#version 150

uniform sampler2D diffuse, normalMap;

uniform float bumpScale = 0.05;

uniform int linSteps = 32;
uniform int binSteps = 8;

uniform int shadowLinSteps = 32;

in vec3 ld, eye; // tangent space
in vec2 tc;

out vec4 colorOut;

void main() {

	float height = 1.0;
	float steps = linSteps;

    // fetch height from normal map (height is in the alpha channel)
	float h = texture(normalMap, tc).a;

    // normalize eye vector
    // eye vector (x,y) provides the direction for the displacement in new texCoord
	vec3 eye_n = normalize(eye);

    // determine the steps based on the Z component
    // the larger the Z the smaller the number of steps
	steps = mix(steps*2, steps, abs(eye_n.z));

    // fraction for each step
	float step = 1.0 / steps;

    // how much to advance per step
	vec2 delta =  bumpScale * vec2(eye_n.x, eye_n.y) * step / abs(eye_n.z);

    // initial value for offset is the initial tex coord
	vec2 offset = tc;

    // loop until we get below the "surface"
	while(h < height) {
		height -= step;
		offset += delta;
		h = texture(normalMap, offset).a;
	}
# if 0 
    // interpolate to get texture displacement
    float fh;
	vec2 d2 = offset;
	vec2 d1 = offset - delta;
    float ph1 = height + step;
    float ph2 = height; 
    float h1 = texture(normalMap, d1).a;
    float h2 = texture(normalMap, d2).a;
    float dh1 = h1 - ph1;
    float dh2 = h2 - ph2;
    fh = (dh1)/(dh2-dh1);
    //fh = 0;
    vec2 d = (1-fh)*d1 + fh * d2;
    offset = d;
#endif
# if 1
    
    // perform binary search to fine tune
	vec2 after = offset;
	vec2 before = offset - delta;
	vec2 middle;
	height += step*0.5;
	for (int i = 0; i < binSteps; ++i) {
		middle = before + (after - before)* 0.5;
		step *= 0.5;
		h = texture(normalMap, middle).a;
		if (h > height) {
			height += step;
			after = middle;
		}
		else {
			height -= step;
			before = middle;
		}
	}
    offset = middle;
#endif

	
	vec4 color = texture(diffuse, offset);

	vec3 n = normalize(texture(normalMap, offset).rgb * 2.0 - 1.0);
	vec3 ld = normalize(ld);
	
	float selfShadow = 0.0;

	float intensity = max(dot(ld, n), 0.0);
	if (intensity > 0.0) {
	
		step = 1.0 / shadowLinSteps;
		delta = bumpScale * vec2(ld.x, ld.y) * step / abs(ld.z);

		//height = h + step;
        //offset += delta;

		do {
		
			height += step;
			offset += delta;
			h = texture(normalMap, offset).a;
		} while (h <= height && height < 1.0);

		if (height < 1.0)
			selfShadow = 0.0;
		else
			selfShadow = 1.0;
	}

	colorOut = (vec4(intensity * selfShadow) + vec4(0.4)) * color ;
}