#version 330

uniform sampler2D diffuse, normalMap;
uniform float scale = 0.04, bias = 0.0;

in vec3 ld, eye; // tangent space
in vec2 tc;

out vec4 colorOut;

void main() {

    // fetch height from normal map (height is in the alpha channel)
	float h = texture(normalMap, tc).a;

    // compute texcoord displacement length based on scale and bias paramente
	float disp_scale = (1-h) * scale - bias;

    // normalize eye vector
    // eye vector (x,y) provides the direction for the displacement in new texCoord
	vec3 eye_n = normalize(eye);

    // compute new texcoord based on computed displacement and eye vector
	vec2 texCoord = tc + disp_scale * vec2(eye_n.x, eye_n.y) / abs(eye_n.z);

    // get normal from normal map using computed texCoord
    vec3 n = texture(normalMap, texCoord).rgb * 2.0 - 1.0;

    // normalize vector
    n = normalize(n);

	float intensity = max(dot(normalize(ld), n), 0.0);

	colorOut = (vec4(intensity) + vec4(0.4)) * texture(diffuse, texCoord);
}