#version 460

// uniforms
uniform sampler2D tex;
uniform float width;
uniform int div;
uniform vec4 diffuse, otherColor;

// interpolated inputs
in vec2 texCoord;

// output
out vec4 color;

void main() {

    vec2 tc = fract(texCoord * div);

    if (tc.s > width)
        color = otherColor;
    else
        color = diffuse;

}