#version 460

// uniforms
uniform sampler2D tex;
uniform float width, gap;
uniform int div;
uniform vec4 diffuse, otherColor;

// interpolated inputs
in vec2 texCoord;

// output
out vec4 color;

void main() {

    float fr = fract(texCoord * div).s;

    float f = smoothstep(width-gap, width, fr) - smoothstep(1-gap, 1.0, fr);

    color = mix(diffuse, otherColor, f);

}