#version 460

// uniforms
uniform sampler2D tex;
uniform float width, gap;
uniform int div;
uniform vec4 diffuse, otherColor;

// interpolated inputs
in vec2 texCoord;

// output
out vec4 color;

void main() {

    float fr = fract(texCoord * div).s;

    if (fr < width - gap)
        color = diffuse;
    else if (fr < width) {
        float f = (fr - (width-gap)) / gap;
        color = mix(diffuse, otherColor, f);
    }
    else if (fr < 1.0 - gap)
        color = otherColor;
    else {
        float f = (fr - (1-gap)) / gap;
        color = mix(otherColor, diffuse, f);
    }
}