#version 460

// uniforms
uniform sampler2D tex;
uniform float width, factor;
uniform int div;
uniform vec4 diffuse, otherColor;

// interpolated inputs
in vec2 texCoord;

// output
out vec4 color;

void main() {

    vec2 tc = texCoord * div;
    float fr = fract(tc.s);

    vec2 deriv = vec2(dFdx(fr), dFdy(fr));

    //vec2 deriv = vec2(dFdx(tc.s), dFdy(tc.s));

    float len = length(deriv);
    float actualGap = len * factor;

    float f = smoothstep(width-actualGap, width, fr) - smoothstep(1-actualGap, 1.0, fr);

    color = mix(diffuse, otherColor, f);

}