#version 460

uniform mat4 m_pvm, m_view;
uniform mat3 m_normal;
uniform vec4 diffuse;

uniform vec4 l_dir;

in vec4 position;
in vec3 normal;

out vec4 color_V;

void main() {

    vec3 n = normalize(m_normal * normal);
    vec4 l4 = m_view * l_dir;
    vec3 l = normalize(vec3(l4));

    float intensity = max(0.0, dot(l,n));

    float i_toon;
    if (intensity > 0.9)
        i_toon = 1.0;
    else if (intensity > 0.66)
        i_toon = 0.66;
    else if (intensity > 0.33)
        i_toon = 0.33;
    else
        i_toon = 0.2;

    color_V = i_toon * diffuse; 


    gl_Position = m_pvm * position;
}