#version 460

uniform vec4 diffuse;
uniform float shininess = 128.0;
uniform float l_cutoff;


in vec3 l,n, e,sd;

out vec4 color;

void main() {

    vec3 ll = normalize(l);
    vec3 nn = normalize(n);
    vec3 sdn = normalize(sd);
    
    float intensity = 0;
    vec4 spec = vec4(0);

    float epsilon = 0.1;
    float cosS = dot(sdn,-ll);
    if (cosS > l_cutoff) {
        float si = smoothstep(l_cutoff, l_cutoff + epsilon, cosS);

        intensity = max(0.0, dot(ll,nn)) * si;

        if (intensity > 0) {
            vec3 h = normalize(normalize(e) + ll);
            float cosA = max(0.0, dot(h,nn));
            spec = vec4(pow(cosA, shininess)) * si;
        }
    }

    color = (intensity + 0.2) * diffuse + spec; 
}