#version 460

uniform mat4 m_pvm, m_view, m_vm;
uniform mat3 m_normal;
uniform vec4 diffuse;
uniform vec4 l_pos;
uniform vec4 l_spotDir;


in vec4 position;
in vec3 normal;

out vec3 l,n,e,sd;

void main() {

    // MUST normalize
    n = normalize(m_normal * normal);

    // do not normalize
    vec4 lp4 = m_view * vec4(l_pos);
    vec4 pp4 = m_vm * position;
    l = vec3(lp4 - pp4);

    sd = vec3(m_view * l_spotDir);

    // do not normalize
    e = vec3(- pp4);

    gl_Position = m_pvm * position;

}