#version 460

uniform vec4 diffuse;
uniform float shininess = 128.0;


in vec3 l,n, e;

out vec4 color;

void main() {

    vec3 ll = normalize(l);
    vec3 nn = normalize(n);
    float intensity = max(0.0, dot(ll,nn));

    vec4 spec = vec4(0);
    if (intensity > 0) {
        vec3 h = normalize(normalize(e) + ll);
        float cosA = max(0.0, dot(h,nn));
        spec = vec4(pow(cosA, shininess));
    }

    color = (intensity) * diffuse + spec; 
}