#version 460

uniform mat4 m_pvm, m_view, m_vm;
uniform mat3 m_normal;
uniform vec4 diffuse;
uniform vec4 l_dir;

in vec4 position;
in vec3 normal;

out vec3 l,n,e;

void main() {

    // MUST normalize
    n = normalize(m_normal * normal);

    // can normalize because it is a directional light
    // directional lights have the same direction for all vertices
    vec4 l4 = m_view * l_dir;
    l = normalize(vec3(l4));

    // direction: in general do not normalize 
    e = vec3(- m_vm * position);

    gl_Position = m_pvm * position;

}