import numpy as np

n = 1000  # Number of particles
box_min = np.array([-10.0, -10.0, -10.0])
box_max = np.array([10.0, 10.0, 10.0])
velocity_range = 5.0

positions = np.random.uniform(box_min, box_max, size=(n, 3))
positions_w = np.zeros((n, 0))
positions_4d = np.hstack([positions, positions_w])

velocities = np.random.uniform(-velocity_range, velocity_range, size=(n, 3))
velocities_w = np.ones((n, 0))
velocities_4d = np.hstack([velocities, velocities_w])

np.savetxt('positions.csv', positions_4d, delimiter=' ', comments='')
np.savetxt('velocities.csv', velocities_4d, delimiter=' ', comments='')
